# Описание ручки
Ручка возвращает список авиакомпаний отсортированных по популярности, а в случае совпадения популярности в лексеграфическом порядке.


## Формат запроса:
```
/rest/airlines/popular/<national_version>/<lang>/<count>
```
*national_version* - национальная версия
*lang* - язык интерфейса пользователя
*count* - количество возвращаемых объектов

## Формат ответа:

```
/rest/airlines/popular/ru/ru/10
{
  "status": "ok",
  "data": [
    {
      "slug": "arkhandelsk-air",
      "id": 8472,
      "title": "2-ой Архангельский объединенный авиаотряд (АУ)",
      "popularity": 103
    },
    ...
    {
      "slug": "aereo-calafia-sa-de-cv",
      "id": 58664,
      "title": "Aereo Calafia S.A. de C.V. (NN)",
      "popularity": 97
    },
    {
      "slug": "p4_aero-lineas-sosa",
      "id": 1473,
      "title": "Aero lineas sosa",
      "popularity": 43
    }
  ]
}
```


## Особенности:
Если название авиакомпании начинается не с русской или английской буквы, то авиакомпания все равно попадет в список

Заголовок состоит из названия авиакомпании и кода(iata/sirena). Код может отсутсвовать.

## Идеи?:
Может стоит отдавать список отсортированный в лексеграфическом порядке, а то иначе получится ситуация равносильная текущей гео страницы.
