from __future__ import absolute_import

from logging import getLogger, Logger  # noqa
from marshmallow import Schema, fields

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.airlines import airline_repository, AirlineRepository  # noqa


class PopularAirlinesForm(Schema):
    national_version = fields.String(required=True)
    lang = fields.String(required=True)
    count = fields.Integer(required=True)


class AirlinesByPopularView(CommonView):
    def __init__(self, airline_repository, logger):
        # type: (AirlineRepository, Logger) -> None
        super(AirlinesByPopularView, self).__init__(
            form=PopularAirlinesForm(),
            logger=logger
        )
        self._airline_repository = airline_repository

    def _process(self, parsed_data):
        national_version = parsed_data[u'national_version']
        lang = parsed_data[u'lang']

        airlines = self._airline_repository.get_all()
        airlines = sorted(
            airlines,
            key=lambda a: (
                -a.get_popular_score(national_version),
                a.get_title_with_code(lang)
            )
        )

        return [
            {
                u'id': airline.pk,
                u'title': airline.get_title_with_code(lang),
                u'slug': airline.slug,
                u'popularity': airline.get_popular_score(national_version),
            } for airline in airlines[:parsed_data[u'count']]
        ]

airlines_by_popular_view = AirlinesByPopularView(
    airline_repository=airline_repository,
    logger=getLogger(__name__)
)
