# -*- coding: utf-8 -*-
from __future__ import absolute_import

from logging import getLogger, Logger  # noqa

from marshmallow import Schema, fields

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.review import review_stat_repository, ReviewStatRepository  # noqa


class FlightReviewsForm(Schema):
    airline_id = fields.Integer(required=True)
    flight_number = fields.String(required=True)


class FlightReviewsView(CommonView):
    def __init__(self, stat_repository, logger):
        # type: (ReviewStatRepository, Logger) -> None
        super(FlightReviewsView, self).__init__(FlightReviewsForm(), logger)
        self._stat_repository = stat_repository

    def _process(self, parsed_data):
        # type: (dict) -> dict
        return self._stat_repository.get(
            parsed_data['airline_id'],
            parsed_data['flight_number'],
        )


flight_reviews_view = FlightReviewsView(
    stat_repository=review_stat_repository,
    logger=getLogger(__name__),
)
