# -*- coding: utf-8 -*-
from __future__ import absolute_import

import logging

from marshmallow import Schema, fields

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.airport_tablo_source import AirportTabloSourceRepository, airport_tablo_source_repository  # noqa


class AirportTabloSourceIndexForm(Schema):
    trusted = fields.Boolean()


class AirportTabloSourceIndexView(CommonView):
    def __init__(self, form, repository, logger):
        # type: (Schema, AirportTabloSourceRepository, logging.Logger) -> None
        super(AirportTabloSourceIndexView, self).__init__(form, logger)
        self._repository = repository

    def _process(self, parsed_form):
        return self._repository.get_not_empty(parsed_form.get('trusted', None))


airport_tablo_source_index_view = AirportTabloSourceIndexView(
    form=AirportTabloSourceIndexForm(),
    repository=airport_tablo_source_repository,
    logger=logging.getLogger(__name__)
)
