# -*- coding: utf-8 -*-
from __future__ import absolute_import

from logging import getLogger

from functools import partial
from typing import List  # noqa

from travel.avia.library.python.common.models.transport import TransportType
from travel.avia.backend.main.rest.helpers import IdsField
from travel.avia.backend.main.rest.airports import AirportForm, AirportAbstractView
from travel.avia.backend.repository.station import station_repository
from travel.avia.backend.repository.settlement import settlement_repository
from travel.avia.backend.repository.country import country_repository
from travel.avia.backend.repository.station_type import station_type_repository


class AirportIndexForm(AirportForm):
    id = IdsField(allow_none=True)


class AirportIndexView(AirportAbstractView):
    def _process(self, parsed_data):
        # type: (dict) -> List[dict]
        if parsed_data.get('id'):
            airports = filter(
                None,
                map(partial(self._repository.get, transport_type=TransportType.PLANE_ID), parsed_data['id'])
            )
        else:
            airports = self._repository.get_all(transport_type=TransportType.PLANE_ID)

        return [
            self._prepare(a, parsed_data['lang']) for a in airports
        ]


airport_index_view = AirportIndexView(
    form=AirportIndexForm(),
    repository=station_repository,
    settlement_repository=settlement_repository,
    country_repository=country_repository,
    station_type_repository=station_type_repository,
    logger=getLogger(__name__),
)
