# -*- coding: utf-8 -*-
from __future__ import absolute_import

from logging import getLogger

from marshmallow import fields

from travel.avia.library.python.common.models.transport import TransportType
from travel.avia.backend.main.rest.airports import AirportForm, AirportAbstractView
from travel.avia.backend.repository.station import station_repository
from travel.avia.backend.repository.settlement import settlement_repository
from travel.avia.backend.repository.country import country_repository
from travel.avia.backend.repository.station_type import station_type_repository


class AirportInfoForm(AirportForm):
    station_id = fields.Integer(required=True)


class AirportInfoView(AirportAbstractView):
    def _process(self, parsed_data):
        # type: (dict) -> dict
        return self._prepare(
            self._repository.get(parsed_data['station_id'], transport_type=TransportType.PLANE_ID),
            parsed_data['lang'],
        )


airport_info_view = AirportInfoView(
    form=AirportInfoForm(),
    repository=station_repository,
    settlement_repository=settlement_repository,
    country_repository=country_repository,
    station_type_repository=station_type_repository,
    logger=getLogger(__name__),
)
