# -*- coding: utf-8 -*-
from logging import getLogger

from marshmallow import fields, Schema

from travel.avia.backend.main.lib.covid_restrictions import get_country_restrictions, get_all_country_restrictions
from travel.avia.backend.main.rest.helpers import CommonView


def format_country_restrictions(country_id, restriction):
    return dict(restriction, countryId=country_id)


class CountryRestrictionsSchema(Schema):
    country_id = fields.Integer(required=False)


class CountryRestrictionsView(CommonView):
    def _process(self, parsed_data):
        country_id = parsed_data.get('country_id')
        restriction = get_country_restrictions(country_id=country_id)
        if restriction:
            return format_country_restrictions(country_id, restriction)
        else:
            return None


class CountriesRestrictionsView(CommonView):
    def _process(self, parsed_data):
        return [
            format_country_restrictions(country_id, restriction)
            for country_id, restriction in get_all_country_restrictions().iteritems()
        ]


country_restrictions_view = CountryRestrictionsView(CountryRestrictionsSchema(), getLogger(__name__))
countries_restrictions_view = CountriesRestrictionsView(Schema(), getLogger(__name__))
