from __future__ import absolute_import

from logging import Logger, getLogger  # noqa

from marshmallow import Schema, fields

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.currency import CurrencyRepository, currency_repository  # noqa


class CurrencyForm(Schema):
    national_version = fields.String(required=True)
    lang = fields.String(required=True)


class CurrencyView(CommonView):
    def __init__(self, currency_repository, logger):
        # type: (CurrencyRepository, Logger) -> None
        super(CurrencyView, self).__init__(
            CurrencyForm(), logger
        )
        self._currency_repository = currency_repository

    def _process(self, parsed_data):
        lang = parsed_data['lang']
        models = self._currency_repository.get_all()

        return [
            {
                u'id': m.pk,
                u'code': m.code,
                u'iso_code': m.iso_code,
                u'title': m.get_title(lang),
                u'title_in': m.get_title_in(lang),
                u'template': m.get_template(lang),
                u'template_whole': m.get_template_whole(lang),
                u'template_cents': m.get_template_cents(lang),
            } for m in models
        ]


currencies_views = CurrencyView(
    currency_repository=currency_repository,
    logger=getLogger(__name__)
)
