from __future__ import absolute_import

from logging import Logger, getLogger  # noqa

from marshmallow import Schema, fields

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.currency import CurrencyRepository, currency_repository  # noqa
from travel.avia.backend.repository.currency_rates import CurrencyRatesRepository, currency_rates_repository  # noqa


class RatesForm(Schema):
    national_version = fields.String(required=True)
    lang = fields.String(required=True)


class RatesView(CommonView):
    def __init__(self, rates_repository, currency_repository, logger):
        # type: (CurrencyRatesRepository, CurrencyRepository, Logger) -> None
        super(RatesView, self).__init__(
            RatesForm(), logger
        )
        self._rates_repository = rates_repository
        self._currency_repository = currency_repository

    def _process(self, parsed_data):
        national_version = parsed_data['national_version']
        rates_by_code = self._rates_repository.get_rates_for(national_version)

        return {
            u'rates': [
                {
                    u'currency_id': self._currency_repository.get_by_code(code).pk,
                    u'rate': rate
                }
                for code, rate in rates_by_code.iteritems()
                if self._currency_repository.get_by_code(code)
            ],
            u'base_currency_id': self._rates_repository.get_base_currency(
                national_version
            ).pk
        }


currency_rates_view = RatesView(
    rates_repository=currency_rates_repository,
    currency_repository=currency_repository,
    logger=getLogger(__name__)
)
