# -*- coding: utf-8 -*-
from __future__ import absolute_import
from logging import getLogger, Logger  # noqa
from marshmallow import Schema, fields

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.flight_rating import FlightRatingRepository, flight_rating_repository  # noqa


class FlightsRatingSchema(Schema):
    flight_number = fields.String(required=True)


class FlightRatingView(CommonView):
    SCHEME = FlightsRatingSchema()

    def __init__(self, flight_rating_repository, logger):
        # type: (FlightRatingRepository, Logger) -> None
        self._flight_rating_repository = flight_rating_repository
        super(FlightRatingView, self).__init__(self.SCHEME, logger)

    def flight_rating_data(self, flight_number):
        flight_rating = self._flight_rating_repository.get(flight_number)
        if not flight_rating:
            return None
        all_fields = [
            'avgScore',
            'badCount',
            'badPercent',
            'canceled',
            'delayedLess30',
            'delayed3060',
            'delayed6090',
            'delayedMore90',
            'goodCount',
            'outrunning',
            'scores',
        ]
        return {field: flight_rating.get(field) for field in all_fields}

    def _process(self, parsed_data):
        # type: (dict) -> dict
        return self.flight_rating_data(parsed_data['flight_number'])


flight_rating_view = FlightRatingView(
    flight_rating_repository, getLogger(__name__)
)
