# coding=utf-8
from __future__ import absolute_import

from logging import getLogger, Logger  # noqa

from marshmallow import Schema, fields

from travel.avia.library.python.common.models.geo import Settlement

from travel.avia.backend.repository.holiday import HolidayRepository  # noqa
from travel.avia.backend.main.lib.holidays.min_prices.directions_with_date_window import search
from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.main.rest.holidays.helpers import get_images_for_holiday_direction_cities
from travel.avia.backend.main.rest.holidays.view_helpers import holiday_index
from travel.avia.backend.repository.holiday import holiday_repository


class HolidayInfoForm(Schema):
    holiday_id = fields.Integer(required=True)
    from_city = fields.String(required=True)
    national_version = fields.String(required=True)
    lang = fields.String(required=True)


class HolidayInfoView(CommonView):
    def __init__(self, holiday_repository, logger):
        # type: (HolidayRepository, Logger) -> None
        super(HolidayInfoView, self).__init__(HolidayInfoForm(), logger)
        self._holiday_repository = holiday_repository

    def _process(self, parsed_data):
        holiday = self._holiday_repository.get_by_id(parsed_data['holiday_id'])
        from_city = Settlement.objects.get(pk=parsed_data['from_city'])
        images_for_holiday_cities = get_images_for_holiday_direction_cities([holiday])
        holiday_directions_map = search(
            holiday=holiday,
            from_city=from_city,
            national_version=parsed_data['national_version'],
            window_size=2,
            results_per_direction=3
        )
        return holiday_index(
            holiday, holiday_directions_map,
            images_for_holiday_cities,
            parsed_data['lang']
        )


holiday_info_view = HolidayInfoView(
    holiday_repository=holiday_repository,
    logger=getLogger(__name__)
)
