# coding=utf-8
from __future__ import absolute_import

from logging import getLogger, Logger  # noqa

from marshmallow import Schema
from marshmallow import fields

from travel.avia.library.python.common.models.geo import Settlement

from travel.avia.backend.repository.holiday import HolidayRepository  # noqa
from travel.avia.backend.main.lib.holidays.min_prices.batch import search
from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.main.rest.holidays.helpers import get_images_for_holiday_direction_cities
from travel.avia.backend.repository.holiday import holiday_repository
from travel.avia.backend.main.rest.holidays.view_helpers import holiday_index


class HolidayIndexForm(Schema):
    from_city = fields.String(required=True)
    national_version = fields.String(required=True)
    lang = fields.String(required=True)


class HolidayIndexView(CommonView):
    def __init__(self, holiday_repository, logger):
        # type: (HolidayRepository, Logger) -> None
        super(HolidayIndexView, self).__init__(HolidayIndexForm(), logger)
        self._holiday_repository = holiday_repository

    def _process(self, parsed_data):
        from_city = Settlement.objects.get(pk=parsed_data['from_city'])
        holidays = self._holiday_repository.get_all()
        images_for_holiday_cities = get_images_for_holiday_direction_cities(holidays)
        holiday_priced_variants_map = search(
            holidays=holidays,
            from_city=from_city,
            national_version=parsed_data['national_version'],
            plus_minus=0,
            batch_size=2
        )
        return [
            holiday_index(
                holiday, holiday_priced_variants_map,
                images_for_holiday_cities,
                parsed_data['lang']
            )
            for holiday in holidays
        ]


holiday_index_view = HolidayIndexView(
    holiday_repository=holiday_repository,
    logger=getLogger(__name__)
)
