from __future__ import absolute_import

from travel.avia.backend.main.lib.display_code_manager import display_code_manager
from travel.avia.backend.repository.settlement import settlement_repository
from travel.avia.backend.repository.country import country_repository


def holiday_index(holiday, holiday_directions_map, direction_city_images, lang):
    return {
        'id': holiday.pk,
        'directionVariants': [
            map_holiday_direction(direction_variant_row, direction_city_images, lang)
            for direction_variant_row in holiday_directions_map[holiday.pk]
        ],
        'nameTankerKey': holiday.name_tanker_key,
        'startDay': holiday.start_day.strftime("%Y-%m-%d"),
        'endDay': holiday.end_day.strftime("%Y-%m-%d")
    }


def map_holiday_direction(direction_variant_row, direction_city_images, lang):
    return {
        'fromCity': map_settlement(direction_variant_row['from_id'], lang),
        'toCity': map_settlement(direction_variant_row['to_id'], lang),
        'forwardDate': direction_variant_row['forward_date'],
        'backwardDate': direction_variant_row['backward_date'],
        'price': direction_variant_row['min_price'],
        'image': map_image(direction_city_images[direction_variant_row['to_id']])
    }


def map_image(image):
    return {
        'url2': image.url2,
        'id': image.pk
    }


def map_settlement(settlement_id, lang):
    settlement = settlement_repository.get(settlement_id)
    if not settlement:
        return {}

    return {
        'id': settlement.pk,
        'key': settlement.point_key,
        'urlTitle': settlement.get_url_title(lang),
        'title': settlement.get_title(lang),
        'phraseFrom': settlement.get_phrase_from(lang),
        'code': display_code_manager.get_code_for_settlement(settlement.pk),
        'iataCode': settlement.iata,
        'country': map_country(settlement.country_id, lang)
    }


def map_country(country_id, lang):
    country = country_repository.get(country_id)
    if not country:
        return {}

    return {
        'id': country.pk,
        'title': country.get_title(lang),
        'urlTitle': country.get_url_title(lang)
    }
