from __future__ import absolute_import

from logging import Logger, getLogger  # noqa

from marshmallow import Schema

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.national_version import NationalVersionRepository, national_version_repository  # noqa


class NationalVersionView(CommonView):
    def __init__(self, national_version_repository,  logger):
        # type: (NationalVersionRepository, Logger) -> None
        super(NationalVersionView, self).__init__(
            Schema(), logger
        )
        self._national_version_repository = national_version_repository

    def _process(self, parsed_data):
        return [
            {
                u'id': model.pk,
                u'code': model.code
            } for model in self._national_version_repository.get_all()
        ]

national_version_view = NationalVersionView(
    national_version_repository=national_version_repository,
    logger=getLogger(__name__)
)
