from __future__ import absolute_import

from typing import List  # noqa

from travel.avia.library.python.avia_data.models import PopularPartnersByRoute

from travel.avia.backend.repository.national_version import (  # noqa
    NationalVersionRepository,
    national_version_repository
)
from travel.avia.backend.repository.partner_popularity import (  # noqa
    partner_popularity_repository,
    route_partner_popularity_repository,
    PartnerPopularityRepository,
    RoutePartnerPopularityRepository,
    PartnerPopularityModel
)


class PartnerPopularityProvider(object):
    def __init__(self, partner_popularity_repository,
                 route_partner_popularity_repository,
                 national_version_repository):
        # type: (PartnerPopularityRepository, RoutePartnerPopularityRepository, NationalVersionRepository) -> None
        self._partner_popularity_repository = partner_popularity_repository
        self._partner_popularity_by_route_repository = \
            route_partner_popularity_repository
        self._national_version_repository = national_version_repository

    def get_for(self, from_point_key, to_point_key, national_version):
        # type: (str, str, str) -> List[PartnerPopularityModel]
        from_type, from_id = self._parse_point_key(from_point_key)
        to_type, to_id = self._parse_point_key(to_point_key)
        national_version_id = national_version_repository.code_to_id(
            national_version
        )
        popular_partners = self._partner_popularity_by_route_repository.get_for(
            national_version_id=national_version_id,
            from_type=from_type,
            from_id=from_id,
            to_type=to_type,
            to_id=to_id
        )

        if popular_partners:
            return popular_partners

        return self._partner_popularity_repository.get_for(
            national_version_id
        )

    @staticmethod
    def _parse_point_key(point_key):
        return PopularPartnersByRoute.POINT_PREFIX_MAP[point_key[0]], int(point_key[1:])


route_partner_popularity_provider = PartnerPopularityProvider(
    partner_popularity_repository=partner_popularity_repository,
    route_partner_popularity_repository=route_partner_popularity_repository,
    national_version_repository=national_version_repository
)
