from __future__ import absolute_import

from flask import Flask  # noqa

from travel.avia.backend.main.rest.airlines import (
    airlines_by_abc_view, airline_index_view, airlines_by_popular_view,
    airline_info_view, airlines_info_view, popular_partners_by_route_view,
    currencies_views, currency_rates_view, national_version_view,
    similar_airlines_view, flight_reviews_view, flights_to_city_airlines_view,
    airlines_synonyms_view,
)
from travel.avia.backend.main.rest.airport_tablo_source.index import airport_tablo_source_index_view
from travel.avia.backend.main.rest.airports.index import airport_index_view
from travel.avia.backend.main.rest.airports.info import airport_info_view
from travel.avia.backend.main.rest.country_restrictions.country_restrictions import (
    country_restrictions_view,
    countries_restrictions_view,
)
from travel.avia.backend.main.rest.country_restrictions.covid_info import covid_info_view
from travel.avia.backend.main.rest.direction.index import direction_index_view
from travel.avia.backend.main.rest.flights.flight_rating import flight_rating_view
from travel.avia.backend.main.rest.geo.country import country_view, countries_view
from travel.avia.backend.main.rest.geo.point import point_view
from travel.avia.backend.main.rest.holidays.index import holiday_index_view
from travel.avia.backend.main.rest.holidays.holiday_info import holiday_info_view
from travel.avia.backend.main.rest.nearby_avia_settlements.index import nearby_avia_settlements
from travel.avia.backend.main.rest.popular_directions_from_settlement.index import popular_directions_from_settlement
from travel.avia.backend.main.rest.sentry_check import sentry_check_log_error, sentry_check_log_traceback
from travel.avia.backend.main.rest.settlements.list import settlement_list_view
from travel.avia.backend.main.rest.transport_model.planes.index import plane_transport_model_index_view
from travel.avia.backend.main.rest.transport_model.planes.info import plane_transport_model_info_view
from travel.avia.backend.main.rest.travel_recipes.index import travel_recipes_view


def add_rest_routes(app):
    # type: (Flask) -> None

    app.add_url_rule(
        '/rest/airlines/index/<national_version>/<lang>',
        'airlines/index',
        airline_index_view.process
    )

    app.add_url_rule(
        '/rest/airlines/abc/<national_version>/<lang>/<start>/<end>',
        'airlines/abc',
        airlines_by_abc_view.process
    )

    app.add_url_rule(
        '/rest/airlines/popular/<national_version>/<lang>/<count>',
        'airlines/popular',
        airlines_by_popular_view.process
    )

    app.add_url_rule(
        '/rest/airlines/similar_airlines/<national_version>/<lang>/<company_id>',
        'airlines/similar_airlines',
        similar_airlines_view.process
    )

    app.add_url_rule(
        '/rest/airlines/flights_to_city/<settlement_id>',
        'airlines/flights_to_city',
        flights_to_city_airlines_view.process
    )

    app.add_url_rule(
        '/rest/airlines/airline_info/<company_id>',
        'airlines/airline_info',
        airline_info_view.process
    )

    app.add_url_rule(
        '/rest/airlines/airline_info',
        'airlines/airlines_info',
        airlines_info_view.process
    )
    app.add_url_rule(
        '/rest/airlines/<airline_id>/flights/<flight_number>/reviews',
        'airlines/flights/reviews',
        flight_reviews_view.process
    )

    app.add_url_rule(
        '/rest/partners/popular_by_route/<national_version>/<lang>/<from_point_key>/<to_point_key>',
        'partners/popular_by_route',
        popular_partners_by_route_view.process
    )

    app.add_url_rule(
        '/rest/currencies/<national_version>/<lang>',
        'currencies',
        currencies_views.process
    )

    app.add_url_rule(
        '/rest/currencies/rates/<national_version>/<lang>',
        'currencies/rates',
        currency_rates_view.process
    )

    app.add_url_rule(
        '/rest/national_versions',
        'national_versions',
        national_version_view.process
    )

    app.add_url_rule(
        '/rest/holidays/<national_version>/<lang>/from_city/<from_city>',
        'holidays/index',
        holiday_index_view.process
    )

    app.add_url_rule(
        '/rest/holidays/<national_version>/<lang>/<holiday_id>/from_city/<from_city>',
        'holidays/holiday_info',
        holiday_info_view.process
    )

    app.add_url_rule(
        '/rest/transport_model/planes',
        'transport_model/planes/index',
        plane_transport_model_index_view.process
    )

    app.add_url_rule(
        '/rest/transport_model/planes/<code_en>',
        'transport_model/planes/info',
        plane_transport_model_info_view.process
    )

    app.add_url_rule(
        '/rest/airports/<station_id>',
        'airports/info',
        airport_info_view.process
    )

    app.add_url_rule(
        '/rest/airports',
        'airports/list',
        airport_index_view.process
    )

    app.add_url_rule(
        '/rest/geo/country/<country_id>',
        'geo/country',
        country_view.process
    )

    app.add_url_rule(
        '/rest/geo/country',
        'geo/countries',
        countries_view.process
    )

    app.add_url_rule(
        '/rest/geo/point',
        'geo/point',
        point_view.process
    )

    app.add_url_rule(
        '/rest/sentry_check/log_error',
        'sentry_check/log_error',
        sentry_check_log_error
    )

    app.add_url_rule(
        '/rest/sentry_check/log_traceback',
        'sentry_check/log_traceback',
        sentry_check_log_traceback
    )

    app.add_url_rule(
        '/rest/settlements',
        'settlements/list',
        settlement_list_view.process
    )

    app.add_url_rule(
        '/rest/direction',
        'direction/index',
        direction_index_view.process
    )

    app.add_url_rule(
        '/rest/airport-tablo-source',
        'airport-tablo-source/index',
        airport_tablo_source_index_view.process,
    )

    app.add_url_rule(
        '/rest/flights/flight_rating/<flight_number>',
        'flights/flight_rating',
        flight_rating_view.process,
    )

    app.add_url_rule(
        '/airlines/synonyms',
        '/airlines/synonyms',
        airlines_synonyms_view.process,
    )

    app.add_url_rule(
        '/rest/travel-recipes',
        'travel-recipes/index',
        travel_recipes_view.process,
    )

    app.add_url_rule(
        '/rest/popular-directions-from-settlement',
        'popular-directions-from-settlement',
        popular_directions_from_settlement.process,
    )

    app.add_url_rule(
        '/rest/nearby-avia-settlements',
        'nearby-avia-settlements',
        nearby_avia_settlements.process,
    )

    app.add_url_rule(
        '/rest/country-restrictions',
        'country-restrictions-all',
        countries_restrictions_view.process,
    )

    app.add_url_rule(
        '/rest/country-restrictions/<country_id>',
        'country-restrictions',
        country_restrictions_view.process,
    )

    app.add_url_rule(
        '/rest/country-restrictions/covid-info',
        'covid-info',
        covid_info_view.process,
    )
