# -*- coding: utf-8 -*-
from __future__ import absolute_import

from logging import getLogger, Logger  # noqa
from typing import List  # noqa

from travel.avia.backend.main.rest.helpers import CommonView, IdsField
from travel.avia.backend.main.rest.settlements import SettlementForm
from travel.avia.backend.repository.settlement import settlement_repository, SettlementRepository, SettlementModel  # noqa


class SettlementsListForm(SettlementForm):
    id = IdsField(allow_none=True)


class SettlementsListView(CommonView):
    def __init__(self, form, repository, logger):
        # type: (SettlementForm, SettlementRepository, Logger) -> None
        super(SettlementsListView, self).__init__(form, logger)
        self._settlement_repository = repository

    def _process(self, parsed_data):
        # type: (dict) -> List[dict]
        if parsed_data.get('id'):
            settlements = filter(None, map(self._settlement_repository.get, parsed_data['id']))
        else:
            settlements = self._settlement_repository.get_all()

        return [
            self._prepare(s, parsed_data['lang']) for s in settlements
        ]

    def _prepare(self, settlement, lang):
        # type: (SettlementModel, str) -> dict
        return settlement.prepare(lang)


settlement_list_view = SettlementsListView(
    form=SettlementsListForm(),
    repository=settlement_repository,
    logger=getLogger(__name__),
)
