# -*- coding: utf-8 -*-
from __future__ import absolute_import

from logging import getLogger, Logger  # noqa
from typing import List  # noqa

from marshmallow import Schema

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.transport_models import (  # noqa
    plane_transport_model_repository, TransportModelRepository, TransportModelDTO
)


class PlaneIndexView(CommonView):
    def __init__(self, repository, logger):
        # type: (TransportModelRepository, Logger) -> None
        super(PlaneIndexView, self).__init__(Schema(), logger)
        self._transport_model_repository = repository

    def _process(self, parsed_data):
        # type: (dict) -> List[TransportModelDTO]
        return self._transport_model_repository.get_all()


plane_transport_model_index_view = PlaneIndexView(
    repository=plane_transport_model_repository,
    logger=getLogger(__name__),
)
