# -*- coding: utf-8 -*-
from __future__ import absolute_import

from logging import getLogger, Logger  # noqa

from marshmallow import Schema, fields

from travel.avia.backend.main.rest.helpers import CommonView
from travel.avia.backend.repository.transport_models import (  # noqa
    plane_transport_model_repository, TransportModelRepository, TransportModelDTO
)


class PlaneInfoForm(Schema):
    code_en = fields.String(required=True)


class PlaneInfoView(CommonView):
    def __init__(self, repository, logger):
        # type: (TransportModelRepository, Logger) -> None
        super(PlaneInfoView, self).__init__(PlaneInfoForm(), logger)
        self._transport_model_repository = repository

    def _process(self, parsed_data):
        # type: (dict) -> TransportModelDTO
        return self._transport_model_repository.get_by_code_en(parsed_data['code_en'])


plane_transport_model_info_view = PlaneInfoView(
    repository=plane_transport_model_repository,
    logger=getLogger(__name__),
)
