# coding=utf-8
from __future__ import absolute_import

import json

from travel.avia.library.python.common.models.holidays import Holiday, HolidayDirection
from travel.avia.library.python.common.models.geo import Settlement


def _get_settlement_id_or_die(raw_code):
    if raw_code[0] != 'c':
        raise Exception('This is not settlement %r' % raw_code)

    return int(raw_code[1:])


def update(file_name, holiday_id, rewrite=False, dry=True):
    holiday = Holiday.objects.get(id=holiday_id)

    directions = set()
    with open(file_name) as input:
        data = json.load(input)

        for r in data:
            try:
                code_to = _get_settlement_id_or_die(r['code_to'])
                code_from = _get_settlement_id_or_die(r['code_from'])

                # проверяем, что города есть
                directions.add((code_to, code_from))
            except Exception as e:
                print e

    settlements_ids = set()
    for from_id, to_id in settlements_ids:
        settlements_ids.add(from_id)
        settlements_ids.add(to_id)

    exiting_settlements_ids = Settlement.objects.filter(id__in=settlements_ids).values_list('id', flat=True)
    if len(exiting_settlements_ids) != len(settlements_ids):
        raise Exception('This settlements do not exist in base : %r', settlements_ids - exiting_settlements_ids)

    prev_directions = HolidayDirection.objects.filter(holiday_id=holiday.id).values_list(
        'settlement_from_id', 'settlement_to_id'
    )
    prev_directions = sorted(prev_directions)

    if dry:
        print("Holiday: ", holiday)
        print("Previous directions:")
        for item in prev_directions:
            print(item)

        print("\nNew directions:")
        directions = list(sorted(directions))
        for item in directions:
            print(item)

        return

    if not rewrite and prev_directions:
        raise Exception("Holiday has directions! If you sure, use rewrite=True")

    for d in HolidayDirection.objects.filter(holiday_id=holiday_id):
        d.delete(using='writable')

    for from_id, to_id in directions:
        HolidayDirection(
            holiday_id=holiday_id,
            settlement_from_id=from_id,
            settlement_to_id=to_id
        ).save(using='writable')
