# -*- coding: utf-8 -*-
from __future__ import absolute_import

import multiprocessing
import os  # noqa
import socket  # noqa

from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.avia_data.settings import *  # noqa
from travel.avia.library.python.common.settings import *  # noqa
from travel.avia.library.python.common.settings.environment import EnvironmentSettings
from travel.avia.library.python.environment_helpers.env_variable_provider import EnvironmentVariableProvider
from travel.avia.library.python.redis.settings import RedisConfigurator

from travel.avia.backend.logging_settings import LOG_PATH, YT_LOG_PATH  # noqa


SERVICE_NAME = 'AVIA_BACKEND'
env_variable_provider = EnvironmentVariableProvider(SERVICE_NAME)

AVIA_WIZARD_NATIONAL_VERSIONS = ['ru', 'kz', 'tr', 'ua']

PKG_VERSION = os.getenv('DEPLOY_DOCKER_IMAGE', 'dev-{}'.format(os.getenv('USER')))

CACHEROOT = '/%s/' % PKG_VERSION

CACHE_PATH = os.getenv('AVIA_CACHE_PATH', '/var/cache/yandex-avia-backend')
DEBUG = TEMPLATE_DEBUG = os.getenv('AVIA_DEBUG', False)
SHOW_LOG = os.path.join(LOG_PATH, 'order', 'show.log')
REDIR_LOG = os.path.join(LOG_PATH, 'order', 'redir.log')
APP_PATH = os.path.abspath(os.path.dirname(__file__))
PROJECT_PATH = os.path.dirname(APP_PATH)
EMAIL_HOST = os.getenv('AVIA_EMAIL_HOST', 'localhost')
MDB_API_TOKEN = os.getenv('AVIA_YC_OAUTH_TOKEN')
YANDEX_ENVIRONMENT_TYPE = os.getenv('YANDEX_ENVIRONMENT_TYPE', 'development')

# Redis flags
CACHE_REDIS = bool(env_variable_provider.get('CACHE_REDIS', required=False) == 'true')
SHARED_CACHE_REDIS = bool(env_variable_provider.get('SHARED_CACHE_REDIS', required=False) == 'true')
REDIS_PING_SLEEP_TIME = int(env_variable_provider.get('REDIS_PING_SLEEP_TIME', required=False, default=1000))
REDIS_MAXIMUM_LAG = int(env_variable_provider.get('MAXIMUM_REDIS_REPLICA_LAG', required=False, default=3000))

ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)

MANAGERS = ADMINS

ERRORS_RECIPIENTS = os.getenv('AVIA_ERRORS_RECIPIENTS', 'rasp-errors@yandex-team.ru').split(',')

DEFAULT_FROM_EMAIL = SERVER_EMAIL = 'yandex-ticket@' + unicode(socket.gethostname())

TIME_ZONE = 'Europe/Moscow'

LANGUAGE_CODE = 'ru'
BASE_LANGUAGE = 'ru'

LANGUAGES = [
    ('ru', _(u'Русский')),
    ('uk', _(u'Украинский')),
    ('tr', _(u'Турецкий')),
    ('en', _(u'Английский')),
    ('de', _(u'Немецкий')),
]

SITE_ID = 1

USE_I18N = True

USE_L10N = True

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = ''

PAGES_ROOT = os.path.join(PROJECT_PATH, 'markup')

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = ''

# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT = ''

# URL prefix for static files.
# Example: "http://media.lawrence.com/static/"
STATIC_URL = '/static/'

# Additional locations of static files
STATICFILES_DIRS = []

# List of finder classes that know how to find static files in
# various locations.
STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    # 'django.contrib.staticfiles.finders.DefaultStorageFinder',
]

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'vuedpm441k5zp)nm3^ykc281v!0+pk3^$r9+*uy$47rge8%*vp'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware'
)

ROOT_URLCONF = 'travel.avia.backend.urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    os.path.join(PROJECT_PATH, 'templates'),
)

TEMPLATE_CONTEXT_PROCESSORS = []

TEMPLATES = [{}]  # workaround for patch_settings_for_arcadia

INSTALLED_APPS = (
    'django.contrib.sites',
    'django.contrib.contenttypes',
    'django.contrib.auth',
    'travel.avia.library.python.common.app_stubs.www',
    'travel.avia.library.python.common.app_stubs.currency',
    'travel.avia.library.python.common.app_stubs.order',
    'travel.avia.library.python.common',
    'travel.avia.library.python.avia_data.django_commands',
    'travel.avia.backend.main.avia_commands',
    'travel.avia.library.python.avia_data',
)

ENVIRONMENT = 'production'

DAYS_TO_PAST = 30
DAYS_TO_FUTURE = 365

# Время жизни кеша
MIN_PRICES_CACHE_TTL = 15 * 60

# Используем загружаемую статику расписаний
RASP_MEDIA_URL = '//yastatic.net/rasp/media/'
DEFAULT_FILE_STORAGE = 'travel.avia.backend.main.lib.storage.RaspFileSystemStorage'

# Нужно для работы is_secure, т.к. django стоит за проксей
SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTOCOL', 'https')

# Не возвращать nearPoints из этих стран для целей отрисовки карты при отсутствии рейсов
# https://st.yandex-team.ru/RASPTICKETS-22697
EXCLUDE_NEAR_POINTS_FROM_COUNTRIES = env_variable_provider.get('EXCLUDE_NEAR_POINTS', required=False, default='').split(',')

# RASPTICKETS-2031 ограничиваем список валют
ALLOWED_CURRENCIES = {
    'ru': ('RUR', 'USD', 'EUR'),
    'ua': ('UAH', 'USD', 'EUR'),
    'tr': ('TRY', 'USD', 'EUR'),
    'com': ('EUR', 'USD', 'GBP'),
    'kz': ('KZT', 'RUR', 'EUR', 'USD'),
}

AVIA_NATIONAL_VERSIONS = ('ru', 'ua', 'tr', 'com', 'kz')
AVIA_NATIONAL_CURRENCIES = {
    'ru': 'RUR',
    'ua': 'UAH',
    'tr': 'TRY',
    'com': 'EUR',
    'kz': 'KZT'
}

DOMAIN_LANGUAGE_MAP = {
    'ru': ('ru', ['ru', 'en']),
    'ua': ('uk', ['uk', 'ru', 'en']),
    'tr': ('tr', ['tr', 'en']),
    'com': ('en', ['en', 'de']),
    'kz': ('ru', ['ru']),
}

# RASPTICKETS-2595 Хитрые города без авиасообщения
SETTLEMENT_ALIASES = {
    1093: 35,  # Майкоп - Краснодар
    22174: 2,  # Великий Новгород - Санкт-Петербург
    1104: 11063,  # Черкесск - Минеральные Воды
    11393: 76,  # Биробиджан - Хабаровск
}


def with_suffix(suffix, prefixes):
    return [prefix + suffix for prefix in prefixes]


PRECACHE = [
    'travel.avia.library.python.common.models.geo:Station.code_manager.precache'
] + with_suffix('.objects.precache', [
    'travel.avia.library.python.common.models.geo:StationType',
    'travel.avia.library.python.common.models.geo:StationMajority',
    'travel.avia.library.python.common.models.geo:StationTerminal',
    'travel.avia.library.python.common.models.geo:Country',
    'travel.avia.library.python.common.models.geo:Region',
    'travel.avia.library.python.common.models.geo:Settlement',
    'travel.avia.library.python.common.models.geo:CodeSystem',
    'travel.avia.library.python.common.models.schedule:Company',
    'travel.avia.library.python.common.models.schedule:Supplier',
    'travel.avia.library.python.common.models.transport:TransportType',
    'travel.avia.library.python.common.models.transport:TransportModel',
    'travel.avia.library.python.common.models.currency:Currency',
    'travel.avia.library.python.avia_data.models.images:SettlementBigImage',
])

MOSCOW_GEO_ID = 213
RUSSIA_GEO_ID = 225

KIEV_GEO_ID = 143
UKRAINE_GEO_ID = 187

ISTANBUL_GEO_ID = 11508
TURKEY_GEO_ID = 983

LONDON_GEO_ID = 10393
BRITAIN_GEO_ID = 102

ASTANA_GEO_ID = 163
KAZAKHSTAN_GEO_ID = 159

BRUSSEL_GEO_ID = 10376
BELGIUM_GEO_ID = 114

# Город по умолчанию для регионального домена. Если для регионального домена не определен город по умолчанию, то
# используется столица страны регионального домена
DEFAULT_CITIES = {
    'tr': ISTANBUL_GEO_ID,
    'com': LONDON_GEO_ID
}

NATIONAL_VERSION_COUNTRY_MAP = {
    'ru': RUSSIA_GEO_ID,
    'tr': TURKEY_GEO_ID,
    'ua': UKRAINE_GEO_ID,
    'com': BRITAIN_GEO_ID,
    'kz': KAZAKHSTAN_GEO_ID
}


AVIA_PRICE_INDEX_URL = os.getenv('AVIA_PRICE_INDEX_URL', 'http://price-index.testing.avia.yandex.net')


CURRENCY_ORDER = {
    'RUR': 10,
    'USD': 20,
    'EUR': 30,
    'UAH': 40,
    'KZT': 50,
    'BYR': 60,
    'TRY': 70,
    'GBP': 80,
}

CURRENCY_ORDER_TR = {
    'RUR': 40,
    'USD': 30,
    'EUR': 20,
    'UAH': 0,
    'KZT': 0,
    'BYR': 0,
    'TRY': 10,
    'GBP': 80,
}

CURRENCY_ORDER_UA = {
    'RUR': 40,
    'USD': 20,
    'EUR': 30,
    'UAH': 10,
    'KZT': 70,
    'BYR': 50,
    'TRY': 60,
    'GBP': 80,
}

NATIONAL_CURRENCY_ORDERS = {
    'ru': CURRENCY_ORDER,
    'tr': CURRENCY_ORDER_TR,
    'ua': CURRENCY_ORDER_UA,
    'com': CURRENCY_ORDER,
    'kz': CURRENCY_ORDER,
}

NATIONAL_CURRENCY_RATES_GEOID = {
    'ru': MOSCOW_GEO_ID,
    'ua': KIEV_GEO_ID,
    'tr': ISTANBUL_GEO_ID,
    'com': BRUSSEL_GEO_ID,
    'kz': KAZAKHSTAN_GEO_ID,
}


PARTNERKA_USERNAME = 'partners'
PARTNERKA_PASSWORD = 'RSpwtzFPMmaCZELlYsNqAcBvJrguVxfK'

PACKAGE_NAME = 'yandex-avia-backend'


def mcr_caches(hosts):
    if not hosts:
        raise ValueError('cannot configure mcrouter cache without hosts')

    return {
        'default': {
            'LOCATION': hosts,
            'TIMEOUT': 60,
            'LONG_TIMEOUT': 24 * 60 * 60,
            'OPTIONS': {'server_max_value_length': 128 * 1024 * 1024},
            'BACKEND': 'travel.avia.backend.main.lib.caches.LoggingMcrouterCache',  # noqa
        }
    }


MCR_DAEMON_CACHES = mcr_caches(
    ['localhost:5000']
)

if os.getenv('AVIA_CACHE_HOST'):
    MCR_DAEMON_CACHES = mcr_caches(['inet6:[%s]:5000' % os.getenv('AVIA_CACHE_HOST')])


@EnvironmentSettings.register_config('development')
def configure_development(environment_settings, settings):
    settings['MCR_DAEMON_CACHES'] = mcr_caches(
        ['localhost:11211']
    )


@EnvironmentSettings.register_config('stress')
def configure_stress(environment_settings, settings):
    settings['MCR_DAEMON_CACHES'] = mcr_caches(
        ['localhost:11211']
    )


_metric_queue = None


def get_metric_queue():
    global _metric_queue
    if _metric_queue is None:
        _metric_queue = multiprocessing.Queue()
    return _metric_queue


def default_cache():
    if CACHE_REDIS:
        return RedisConfigurator(
            service_name=env_variable_provider.get('REDIS_SENTINEL_SERVICE_NAME'),
            redis_cluster_id=env_variable_provider.get('REDIS_CLUSTER_ID'),
            redis_password=env_variable_provider.get('REDIS_PASSWORD'),
            redis_port=int(env_variable_provider.get('REDIS_PORT', required=False, default=26379)),
            socket_timeout=float(env_variable_provider.get('REDIS_SOCKET_TIMEOUT', required=False, default=0.1)),
            oauth_token=os.getenv('AVIA_YC_OAUTH_TOKEN'),
            monitoring_sensor_prefix='default_cache',
            monitoring_metric_queue=get_metric_queue(),
        ).configure_redis()['default']
    else:
        return MCR_DAEMON_CACHES['default']


def shared_cache():
    if SHARED_CACHE_REDIS:
        return RedisConfigurator(
            service_name=env_variable_provider.get('SHARED_REDIS_SENTINEL_SERVICE_NAME'),
            redis_cluster_id=env_variable_provider.get('SHARED_REDIS_CLUSTER_ID'),
            redis_password=env_variable_provider.get('SHARED_REDIS_PASSWORD'),
            redis_port=int(env_variable_provider.get('SHARED_REDIS_PORT', required=False, default=26379)),
            socket_timeout=float(env_variable_provider.get('SHARED_REDIS_SOCKET_TIMEOUT', required=False, default=0.1)),
            oauth_token=os.getenv('AVIA_YC_OAUTH_TOKEN'),
            monitoring_sensor_prefix='shared_cache',
            monitoring_metric_queue=get_metric_queue(),
        ).configure_redis_master_only()['default']
    else:
        return MCR_DAEMON_CACHES['default']


# RASPTICKETS-2485
BILLING_PLATFORM_RASP = 501            # 501 - десктоп Расписаний
BILLING_PLATFORM_AVIA = 502            # 502 - десктоп Авиабилетов
BILLING_PLATFORM_IOS = 503             # 503 - приложение Авиабилетов под iOS
BILLING_PLATFORM_ANDROID = 504         # 504 - приложение Авиабилетов под андроид
BILLING_PLATFORM_WINDOWS_PHONE = 505   # 505 - приложение Авиабилетов windows phone
BILLING_PLATFORM_IPAD = 506            # 506 - приложение Авиабилетов для ipad
BILLING_PLATFORM_ANDROID_TABLET = 507  # 507 - приложение Авиабилетов для android tablet

# TVM
TVM_IS_FAKE = env_variable_provider.get('TVM_IS_FAKE', required=True) == 'true'
TVM_TOKEN = env_variable_provider.get('AVIA_BACKEND_TVM_TOKEN', required=False,
                                      default=env_variable_provider.get(
                                          'TVMTOOL_LOCAL_AUTHTOKEN', required=False, default=None
                                      ))
TVM_NAME = env_variable_provider.get('TVM_NAME', required=True)
TVM_IN_STRICT_MODE = env_variable_provider.get('TVM_IN_STRICT_MODE', required=True) == 'true'
TVM_SERVICE_ID = env_variable_provider.get('TVM_ID', required=True)

PAUSE_PING_RESPONSES_FLAGFILE = '/tmp/avia_backend_pause_ping_responses_flag'

ALLOW_GEOBASE = True

# RASPTICKETS-17960
MYSQL_READ_TIMEOUT = 20
