# -*- encoding: utf-8 -*-
from __future__ import absolute_import

import logging


from django.conf import settings


log = logging.getLogger(__name__)


def get_billing_platform_by_platform(platform):
    billing_platform = {
        'android': settings.BILLING_PLATFORM_ANDROID,
        'ios': settings.BILLING_PLATFORM_IOS,
        'web': settings.BILLING_PLATFORM_AVIA,
        'wp': settings.BILLING_PLATFORM_WINDOWS_PHONE,
    }.get(platform)

    if billing_platform is None:
        log.warning(u'Unknown platform: %s', platform)
        billing_platform = settings.BILLING_PLATFORM_AVIA

    return billing_platform
