# -*- encoding: utf-8 -*-
from __future__ import absolute_import


def _fetch_cached_o2m_field(objects, field, model=None):
    if model is None:
        model = getattr(objects, 'model', None)

        if model is None:
            raise ValueError(
                'Please pass queryset or specify model directly')

    model_field = getattr(model, field).field
    field_name = model_field.m2m_field_name()
    reverse_name = model_field.m2m_reverse_name()
    through_model = model_field.rel.through
    related_model = model_field.rel.to

    relations = through_model.objects.filter(**{
        '%s__in' % field_name: [obj.id for obj in objects]
    }).values_list(field_name, reverse_name)

    relations = {}
    for rel in relations:
        items = relations.setdefault(rel[0], [])
        items.append(related_model.objects.get(id=rel[1]))

    cached_field_name = '%s_cached' % field
    for obj in objects:
        setattr(obj, cached_field_name, relations.get(obj.id, []))


def fetch_related_many(objects, *fields):
    """ Вытаскивает one to many объекты из кэша,
        устанавливает результат моделям в <запрошенный field>_cached

        не стоит его использовать когда связанных объектов очень много
    """

    for field in fields:
        _fetch_cached_o2m_field(objects, field)
