from __future__ import absolute_import

from typing import Optional  # noqa

from travel.avia.library.python.avia_data.models import CompanyRating


class AirlineRatingRepository(object):
    MIN_FLIGHT_COUNT = 5

    def __init__(self):
        self._index = {}

    def pre_cache(self):
        # type: () -> None
        index = {}
        for rating in CompanyRating.objects.all():
            index[rating.company.id] = {
                'avgScore': rating.avg_scores,
                'badCount': rating.bad_count,
                'badPercent': rating.bad_percent,
                'canceled': rating.canceled,
                'delayedLess30': rating.delayed_less_30,
                'delayed3060': rating.delayed_30_60,
                'delayed6090': rating.delayed_60_90,
                'delayedMore90': rating.delayed_more_90,
                'flightCount': rating.flight_count,
                'goodCount': rating.good_count,
                'outrunning': rating.outrunning,
                'scores': rating.scores,
            }
        self._index = index

    def get(self, company_id):
        # type: (int) -> Optional[dict]

        rating = self._index.get(company_id)
        if rating and rating['flightCount'] > self.MIN_FLIGHT_COUNT:
            return rating
        return None


airline_rating_repository = AirlineRatingRepository()
