from __future__ import absolute_import

from typing import List, Optional  # noqa

from travel.avia.library.python.avia_data.models.tablo import AirportTabloSource as Model


class AirportTabloSource(object):
    __slots__ = ('airport_id', 'source', 'trusted')

    def __init__(self, airport_id, source, trusted):
        self.airport_id = airport_id
        self.source = source
        self.trusted = trusted


class AirportTabloSourceRepository(object):
    @staticmethod
    def get_not_empty(trusted=None):
        # type: (Optional[bool]) -> List[AirportTabloSource]
        q = Model.objects.exclude(source__isnull=True)

        if trusted is not None:
            q = q.filter(trusted=trusted)

        return [
            AirportTabloSource(v['station_id'], v['source__code'], v['trusted'])
            for v in q.values('station_id', 'source__code', 'trusted')
        ]


airport_tablo_source_repository = AirportTabloSourceRepository()
