from __future__ import absolute_import

from typing import Optional  # noqa

from travel.avia.library.python.avia_data.models import FlightRating


class FlightRatingRepository(object):
    def __init__(self):
        self._index = {}

    def pre_cache(self):
        # type: () -> None
        index = {}
        for rating in FlightRating.objects.all():
            index[rating.number.replace(u' ', u'-')] = {
                'avgScore': rating.avg_scores,
                'badCount': rating.bad_count,
                'badPercent': rating.bad_percent,
                'canceled': rating.canceled,
                'delayedLess30': rating.delayed_less_30,
                'delayed3060': rating.delayed_30_60,
                'delayed6090': rating.delayed_60_90,
                'delayedMore90': rating.delayed_more_90,
                'goodCount': rating.good_count,
                'outrunning': rating.outrunning,
                'scores': rating.scores,
            }
        self._index = index

    def get(self, flight_number):
        # type: (int) -> Optional[dict]

        return self._index.get(flight_number)


flight_rating_repository = FlightRatingRepository()
