from __future__ import absolute_import

from operator import itemgetter

from typing import List  # noqa

from travel.avia.library.python.common.utils.iterrecipes import group_by

from travel.avia.library.python.avia_data.models import RelevantCityAirline


class FlightsToCityAirlinesRepository(object):
    def __init__(self):
        self._index = {}

    def pre_cache(self):
        # type: () -> None
        flights_to_city_airlines = (
            RelevantCityAirline.objects.all()
            .select_related('national_version__code')
            .values('settlement_to_id', 'national_version__code', 'airline_id',
                    'score')
        )

        index = group_by(
            flights_to_city_airlines,
            itemgetter('settlement_to_id', 'national_version__code')
        )
        self._index = {
            k: sorted(v, key=itemgetter('score'), reverse=True)
            for k, v in index
        }

    def get(self, settlement_id, national_version):
        # type: (int, basestring) -> List[dict]
        return self._index.get((settlement_id, national_version), [])

    def get_top_n(self, settlement_id, national_version, n):
        # type: (int, basestring, int) -> List[dict]
        return self.get(settlement_id, national_version)[:n]


flights_to_city_airlines_repository = FlightsToCityAirlinesRepository()
