from __future__ import absolute_import

from typing import Optional  # noqa

from travel.avia.library.python.common.models.partner import Partner


class PartnerModel(object):
    __slots__ = ('pk', 'code')

    def __init__(self, pk, code):
        self.pk = pk
        self.code = code


class PartnerRepository(object):
    def __init__(self):
        # type: () -> None
        self._by_id = {}
        self._by_code = {}

    def pre_cache(self):
        # type: () -> None

        by_id = {}
        by_code = {}
        records = Partner.objects.all().values_list(
            'id', 'code'
        )
        for model_id, code in records:
            model = PartnerModel(model_id, code)
            by_id[model_id] = model
            by_code[code] = model

        self._by_id = by_id
        self._by_code = by_code

    def get_by_id(self, model_id):
        # type: (int) -> Optional[PartnerModel]
        return self._by_id.get(model_id)

    def get_by_code(self, code):
        # type: (str) -> Optional[PartnerModel]
        return self._by_code.get(code)


partner_repository = PartnerRepository()
