from __future__ import absolute_import

from collections import defaultdict

from typing import List  # noqa

from travel.avia.library.python.avia_data.models import SimilarAirlines


class SimilarAirlinesRepository(object):
    def __init__(self):
        self._index = {}

    def pre_cache(self):
        # type: () -> None
        index = defaultdict(list)
        for a in SimilarAirlines.objects.all():
            index[a.airline_id].append({'company_id': a.similar_airline_id, 'score': a.score})

        self._index = dict(index)

    def get(self, company_id):
        # type: (int) -> List[dict]
        return self._index.get(company_id, [])


similar_airlines_repository = SimilarAirlinesRepository()
