from __future__ import print_function

import argparse

import django
django.setup()

from travel.avia.library.python.common.models.partner import PartnerUser

from travel.avia.backend.main.lib.partner_users import create_partner_user


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--role', choices=[x[0] for x in PartnerUser.ROLES])
    parser.add_argument('--partner-code')
    parser.add_argument('--login')
    parser.add_argument('--name')

    args = parser.parse_args()

    create_partner_user(args.role, args.login, args.name, args.partner_code)
    print('User was created')

if __name__ == '__main__':
    main()
