from __future__ import absolute_import

import logging

logger = logging.getLogger(__name__)


def fill_partner_puids():
    from travel.avia.library.python.common.models.partner import PartnerUser
    from travel.avia.backend.main.lib.blackbox_utils import get_uid

    for user in PartnerUser.objects.all():
        login = user.login.strip()
        puid = get_uid(login)
        if puid is None:
            logger.warning('Can not find puid for %s', login)
        else:
            user.passportuid = puid
            user.save(using='writable')
            logger.info('Save for %s', login)


if __name__ == '__main__':
    import django

    django.setup()

    fill_partner_puids()
