PY2TEST()

OWNER(g:avia)

PEERDIR(
    contrib/python/Faker

    travel/avia/backend

    travel/avia/library/python/common
    travel/avia/library/python/tester
)

IF(NOT SKIP_TESTS_RECIPE)
    INCLUDE(${ARCADIA_ROOT}/travel/avia/library/python/recipe/recipe.inc)
ENDIF()

PY_SRCS(
    conftest.py
    factories.py
    tests_settings.py

    main/rest/transport_model/planes/base_test_case.py
    main/rest/airports/base_test_case.py

    main/api_test.py

    main/fabriks/__init__.py
    main/fabriks/airport.py
    main/fabriks/country.py
    main/fabriks/region.py
    main/fabriks/settlement.py
    main/fakes/__init__.py
    main/fakes/airport_repository.py
    main/fakes/country_repository.py
    main/fakes/display_code_manager.py
    main/fakes/fake_national_version_repository.py
    main/fakes/geo_relation_repository.py
    main/fakes/region_repository.py
    main/fakes/settlement_repository.py
)

TEST_SRCS(
    main/rest/airlines/__init__.py
    main/rest/airlines/test_abc.py
    main/rest/airlines/test_airline_info.py
    main/rest/airlines/test_airlines_synonyms.py
    main/rest/airlines/test_flights_to_city.py
    main/rest/airlines/test_helpers.py
    main/rest/airlines/test_index.py
    main/rest/airlines/test_popular.py
    main/rest/airlines/test_reviews.py
    main/rest/airlines/test_similar_airlines.py

    main/rest/airport_tablo_source/__init__.py
    main/rest/airport_tablo_source/test_index.py

    main/rest/airports/__init__.py
    main/rest/airports/test_index.py
    main/rest/airports/test_info.py

    main/rest/country_restrictions/test_country_restrictions.py
    main/rest/country_restrictions/test_covid_info.py

    main/rest/currency/__init__.py
    main/rest/currency/test_currency.py
    main/rest/currency/test_rates.py

    main/rest/direction/__init__.py
    main/rest/direction/test_index.py

    main/rest/geo/__init__.py
    main/rest/geo/test_country.py
    main/rest/geo/test_point.py

    main/rest/holidays/__init__.py

    main/rest/nearby_avia_settlements/__init__.py
    main/rest/nearby_avia_settlements/test_index.py

    main/rest/partners/__init__.py
    main/rest/partners/test_helpers.py
    main/rest/partners/test_popular_by_route.py

    main/rest/popular_directions_from_settlement/__init__.py
    main/rest/popular_directions_from_settlement/test_index.py

    main/rest/settlements/__init__.py
    main/rest/settlements/test_index.py

    main/rest/transport_model/planes/__init__.py
    main/rest/transport_model/planes/test_index.py
    main/rest/transport_model/planes/test_info.py

    main/rest/travel_recipes/__init__.py
    main/rest/travel_recipes/test_index.py

    main/api/__init__.py
    main/api/test_api_handler.py
    main/api/test_fields.py
    main/api_types/__init__.py
    main/api_types/test_balance.py
    main/api_types/test_client_settlement.py
    main/api_types/test_company.py
    main/api_types/test_country_direction.py
    main/api_types/test_direction.py
    main/api_types/test_geo_cities.py
    main/api_types/test_geo_lookup.py
    main/api_types/test_good_price.py
    main/api_types/test_info.py
    main/api_types/test_min_prices.py
    main/api_types/test_near_directions.py
    main/api_types/test_neighbour_country_directions.py
    main/api_types/test_partnerka.py
    main/api_types/test_partnersData.py
    main/api_types/test_partnersData_Source.py
    main/api_types/test_partnersLogins.py
    main/api_types/test_recipe.py
    main/api_types/test_recipe_offers.py
    main/api_types/test_reviews.py
    main/api_types/test_schedule.py
    main/api_types/test_settlement.py
    main/api_types/test_settlement_image.py
    main/api_types/test_similar_directions.py
    main/api_types/test_station.py
    main/api_types/test_top_flights.py
    main/api_types/test_wizardPartners.py
    main/application/__init__.py
    main/application/test_shutdown.py
    main/lib/test_covid_restrictions.py
    main/lib/test_display_code_manager.py
    main/lib/test_file_flag.py
    main/lib/test_geo.py
    main/partnerka/__init__.py
    main/partnerka/test_create_partner.py
    main/partnerka/test_partner_statuses.py
    main/test_health.py

    repository/__init__.py
    repository/test_airline.py
    repository/test_airline_rating.py
    repository/test_airport_tablo_source.py
    repository/test_company.py
    repository/test_country.py
    repository/test_covid_info.py
    repository/test_currency.py
    repository/test_currency_rates.py
    repository/test_currency_translation.py
    repository/test_direction.py
    repository/test_flight_rating.py
    repository/test_flights_to_city_airlines.py
    repository/test_iata_correction.py
    repository/test_national_version.py
    repository/test_partner.py
    repository/test_partner_popularity.py
    repository/test_region.py
    repository/test_review.py
    repository/test_settlement.py
    repository/test_settlement_big_image.py
    repository/test_settlement_geo_index.py
    repository/test_similar_airlines.py
    repository/test_translations.py
    repository/test_transport_models.py
)

NO_CHECK_IMPORTS()  # do not pass becouse of django

SIZE(MEDIUM)

ENV(AVIA_BACKEND_TVM_IS_FAKE=)
ENV(AVIA_BACKEND_TVM_NAME=)
ENV(AVIA_BACKEND_TVM_IN_STRICT_MODE=)
ENV(AVIA_BACKEND_TVM_ID=)

END()
