#!/usr/bin/env bash

ROOT=$(pwd)
LOGIN=$(whoami)

export YANDEX_ENVIRONMENT_TYPE=development

export DEPLOY_NODE_DC=sas

export AVIA_LOG_PATH=$ROOT/log
export AVIA_BACKEND_BIND_ADDRESS="unix:/tmp/avia-backend.sock"
export AVIA_BACKEND_GUNICORN_WORKERS_COUNT=1
export AVIA_BACKEND_TVM_IN_STRICT_MODE="false"
export AVIA_BACKEND_TVM_IS_FAKE="true"
export AVIA_BACKEND_TVM_NAME="avia-backend-testing"
export AVIA_BACKEND_TVM_TOKEN="some"
export AVIA_YC_OAUTH_TOKEN="token"
export AVIA_BACKEND_TVM_ID=2000569 # testing

# https://wiki.yandex-team.ru/passport/tvm2/tvm-daemon/
export TVM_TOOL_TOKEN="see /var/lib/tvmtool/local.auth"
export TVM_TOOL_URL="http://localhost:18080/tvm"

# testing redis
export AVIA_BACKEND_CACHE_REDIS=true
export AVIA_BACKEND_REDIS_CLUSTER_ID=mdbqu33ph83ndlsrnq2h
export AVIA_BACKEND_REDIS_SENTINEL_SERVICE_NAME=backend-storage-testing
export AVIA_BACKEND_REDIS_PASSWORD=# see https://yav.yandex-team.ru/secret/sec-01fegeqshx5232tktym9xz1bfd

export AVIA_BACKEND_SHARED_CACHE_REDIS=true
export AVIA_BACKEND_SHARED_REDIS_CLUSTER_ID=mdb943sp1285mev6uomm
export AVIA_BACKEND_SHARED_REDIS_SENTINEL_SERVICE_NAME=common-storage-testing
export AVIA_BACKEND_SHARED_REDIS_PASSWORD=# see https://yav.yandex-team.ru/secret/sec-01feawvg53gw35nam91h2n43bm
