PY2_LIBRARY(backend)

OWNER(g:avia)

PEERDIR(
    # Avia libs (was git submodules)
    travel/avia/library/python/avia_data
    travel/avia/library/python/common
    travel/avia/library/python/geosearch
    travel/avia/library/python/route_search

    # hemi
    travel/rasp/library/python/hemi

    # Avia dependencies
    travel/avia/library/python/balance_client
    travel/avia/library/python/environment_helpers
    travel/avia/library/python/error_booster/raven
    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/http_geobase
    travel/avia/library/python/redis
    travel/avia/library/python/shared_objects

    # Travel dependencies
    travel/library/python/avia_mdb_replica_info
    travel/library/python/cloud_logger
    travel/library/python/gunicorn/worker_watcher
    travel/library/python/solomon
    travel/library/python/tvm_ticket_provider

    # Tracing dependencies
    travel/library/python/tracing/flask_opentracing_helpers
    contrib/python/Flask-OpenTracing
    contrib/python/jaeger-client
    contrib/python/tornado/tornado-4
    contrib/python/opentracing-instrumentation

    # For good console in manage.py
    contrib/python/ipython

    # Other dependencies
    contrib/python/attrs
    contrib/python/Babel
    contrib/python/cachetools
    contrib/python/beautifulsoup4
    contrib/python/blinker
    contrib/python/click
    contrib/python/cachetools
    contrib/python/decorator
    contrib/python/django/django-1.11
    contrib/python/django-redis
    contrib/python/django-bootstrap3
    contrib/python/django-filter
    contrib/python/djangorestframework
    contrib/python/enum34
    contrib/python/Flask
    contrib/python/Flask-Admin
    contrib/python/flask-cors
    contrib/python/Flask-Login
    contrib/python/flask-mongoengine
    contrib/python/Flask-Script
    contrib/python/geoindex
    contrib/python/gevent
    contrib/python/greenlet
    contrib/python/gunicorn
    contrib/python/httplib2
    contrib/python/itsdangerous
    contrib/python/marshmallow/py2
    contrib/python/MySQL-python
    contrib/python/mongoengine
    contrib/python/mongolock
    contrib/python/more-itertools
    contrib/python/networkx
    contrib/python/openpyxl
    contrib/python/psycopg2
    contrib/python/pycountry
    contrib/python/Pygments
    contrib/python/pymongo
    contrib/python/PyMySQL
    contrib/python/pyOpenSSL
    contrib/python/pytest
    contrib/python/pytz
    contrib/python/dateutil
    contrib/python/Pillow
    contrib/python/python-memcached
    contrib/python/pytils
    contrib/python/raven
    contrib/python/redis
    contrib/python/requests
    contrib/python/retrying
    contrib/python/scour
    contrib/python/setproctitle
    contrib/python/setuptools
    contrib/python/sqlparse
    contrib/python/six
    contrib/python/statsd
    contrib/python/timeout-decorator
    contrib/python/typing
    contrib/python/ujson
    contrib/python/Unidecode
    contrib/python/Werkzeug
    contrib/python/zeep

    # Yandex libs
    library/python/gunicorn
    library/python/python-django-tanker
    library/python/python-django-yauth
    library/python/ylog
    library/python/yt
    yql/library/python
)

PY_SRCS(
    TOP_LEVEL
    local_settings.py
)

PY_SRCS(
    app.py
    gunicorn_conf.py
    logging_settings.py
    main/api/__init__.py
    main/api/api_handler.py
    main/api/api_schema.py
    main/api/fields.py
    main/api/processors.py
    main/api/register.py
    main/api_types/__init__.py
    main/api_types/air_traffic_recovery.py
    main/api_types/airline_recipe.py
    main/api_types/balance.py
    main/api_types/best_offers.py
    main/api_types/bug_mail.py
    main/api_types/client_settlement.py
    main/api_types/company.py
    main/api_types/country.py
    main/api_types/country_directions.py
    main/api_types/country_offers.py
    main/api_types/currency.py
    main/api_types/direction.py
    main/api_types/dohopPartners.py
    main/api_types/flight_numbers_to_company_ids.py
    main/api_types/geo_cities.py
    main/api_types/geo_countries.py
    main/api_types/geo_lookup.py
    main/api_types/good_price.py
    main/api_types/info.py
    main/api_types/near_directions.py
    main/api_types/neighbour_country_directions.py
    main/api_types/offers.py
    main/api_types/partnerka.py
    main/api_types/partners.py
    main/api_types/partnersData.py
    main/api_types/partnersLogins.py
    main/api_types/price.py
    main/api_types/recipe.py
    main/api_types/recipe_offers.py
    main/api_types/reference.py
    main/api_types/reviews.py
    main/api_types/schedule.py
    main/api_types/settlement.py
    main/api_types/settlement_image.py
    main/api_types/similar_directions.py
    main/api_types/station.py
    main/api_types/top_flight.py
    main/api_types/wizardPartners.py
    main/application.py
    main/avia_commands/management/commands/get_company_colors.py
    main/avia_commands/management/commands/update_company_colors.py
    main/avia_commands/management/commands/warm_restart.py
    main/health.py
    main/lib/__init__.py
    main/lib/access.py
    main/lib/basic_auth.py
    main/lib/blackbox_utils.py
    main/lib/caches.py
    main/lib/covid_restrictions.py
    main/lib/db.py
    main/lib/directions.py
    main/lib/display_code_manager.py
    main/lib/exceptions.py
    main/lib/fields.py
    main/lib/file_flag.py
    main/lib/geo.py
    main/lib/holidays/__init__.py
    main/lib/holidays/min_prices/__init__.py
    main/lib/holidays/min_prices/batch.py
    main/lib/holidays/min_prices/directions_with_date_window.py
    main/lib/log.py
    main/lib/partner_users.py
    main/lib/prices.py
    main/lib/profile.py
    main/lib/rates.py
    main/lib/recipe_provider.py
    main/lib/recipes/__init__.py
    main/lib/recipes/airline.py
    main/lib/recipes/filters.py
    main/lib/recipes/popular.py
    main/lib/recipes/recipe_direction_finder.py
    main/lib/settlement.py
    main/lib/settlement_serializer.py
    main/lib/storage.py
    main/lib/timer.py
    main/localize.py
    main/middleware.py
    main/models.py
    main/rest/airlines/__init__.py
    main/rest/airlines/abc.py
    main/rest/airlines/airline_info.py
    main/rest/airlines/airlines_synonyms.py
    main/rest/airlines/flights_to_city.py
    main/rest/airlines/helpers.py
    main/rest/airlines/index.py
    main/rest/airlines/popular.py
    main/rest/airlines/reviews.py
    main/rest/airlines/similar_airlines.py
    main/rest/airport_tablo_source/__init__.py
    main/rest/airport_tablo_source/index.py
    main/rest/airports/__init__.py
    main/rest/airports/index.py
    main/rest/airports/info.py
    main/rest/country_restrictions/country_restrictions.py
    main/rest/country_restrictions/covid_info.py
    main/rest/currency/currency.py
    main/rest/currency/rates.py
    main/rest/direction/index.py
    main/rest/flights/__init__.py
    main/rest/flights/flight_rating.py
    main/rest/geo/__init__.py
    main/rest/geo/country.py
    main/rest/geo/point.py
    main/rest/helpers.py
    main/rest/holidays/__init__.py
    main/rest/holidays/helpers.py
    main/rest/holidays/holiday_info.py
    main/rest/holidays/index.py
    main/rest/holidays/view_helpers.py
    main/rest/national_version/__init__.py
    main/rest/nearby_avia_settlements/__init__.py
    main/rest/nearby_avia_settlements/index.py
    main/rest/partners/__init__.py
    main/rest/partners/helpers.py
    main/rest/partners/popular_by_route.py
    main/rest/popular_directions_from_settlement/__init__.py
    main/rest/popular_directions_from_settlement/index.py
    main/rest/routes.py
    main/rest/sentry_check/__init__.py
    main/rest/settlements/__init__.py
    main/rest/settlements/list.py
    main/rest/transport_model/__init__.py
    main/rest/transport_model/planes/__init__.py
    main/rest/transport_model/planes/index.py
    main/rest/transport_model/planes/info.py
    main/rest/travel_recipes/__init__.py
    main/rest/travel_recipes/index.py
    main/scripts/__init__.py
    main/scripts/update_holidays.py
    main/services/__init__.py
    main/services/price_index.py
    main/settings.py
    main/utils/__init__.py
    main/utils/models.py
    repository/__init__.py
    repository/airline_rating.py
    repository/airlines.py
    repository/airport_tablo_source.py
    repository/company.py
    repository/country.py
    repository/covid_info.py
    repository/currency.py
    repository/currency_rates.py
    repository/currency_translation.py
    repository/direction.py
    repository/flight_rating.py
    repository/flights_to_city_airlines.py
    repository/helpers.py
    repository/holiday.py
    repository/iata_correction.py
    repository/national_version.py
    repository/partner.py
    repository/partner_popularity.py
    repository/recipe.py
    repository/region.py
    repository/review.py
    repository/s2s.py
    repository/settlement.py
    repository/settlement_big_image.py
    repository/similar_airlines.py
    repository/station.py
    repository/station_type.py
    repository/translations.py
    repository/transport_models.py
    scripts/__init__.py
    scripts/single/__init__.py
    scripts/single/create_partner_user.py
    scripts/single/currency_translation_optimize.py
    scripts/single/fill_puids.py
    scripts/single/make_aviacompanies.py
    urls.py
    watch.py
    wsgi.py
)

RESOURCE_FILES(
    PREFIX travel/avia/backend/
    main/lib/data/covid_restrictions.csv
)

END()

RECURSE_FOR_TESTS(
    tests
)

RECURSE(
    bin
)
