package messages

import (
	"time"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/avia/chatbot/public/botapi"
)

func PutWithTimeout(ch chan<- botapi.Response, resp botapi.Response, timeout time.Duration) error {
	select {
	case ch <- resp:
		return nil

	case <-time.After(timeout):
		return xerrors.New("timeout")
	}
}
