package messages

import (
	"fmt"
	"time"

	"gopkg.in/tucnak/telebot.v2"

	"a.yandex-team.ru/travel/avia/chatbot/public/botapi"
)

type StartHandler struct {
}

const helloStartText = "Привет, %s. Я бот Я.Путешествий. Я могу подсказать тебе статус рейса и подписать тебя на изменение цены. ✈️\n" +
	"Для получения статуса рейса просто введи его номер в формате `SU 1404` или `SU 1404 2021-10-01` для статуса рейса на конкретную дату.\n" +
	"Для подписки на изменение цены нужно использовать команду `/s с213_с239_2021-10-01_None_1_0_0_economy_ru +багаж`." +
	"За смыслом можно сходить к кому-нибудь из команды Авиабилетов.\n" +
	"Disclaimer: сервис подписки работает в pre-альфа режиме и может забыть вашу подписку не предупредив об этом.🤯"

func (s StartHandler) Handle(message telebot.Message) <-chan botapi.Response {
	ch := make(chan botapi.Response)
	go func() {
		defer close(ch)
		_ = PutWithTimeout(ch, botapi.Response{Text: fmt.Sprintf(helloStartText, message.Chat.FirstName)}, 10*time.Second)
	}()
	return ch
}

func (s StartHandler) ShouldHandle(m telebot.Message) bool {
	return m.Text == "/start"
}
