package settings

type Config struct {
	Telegram  Telegram  `yaml:"telegram"`
	Logbroker Logbroker `yaml:"logbroker"`
}

type Telegram struct {
	Token     string  `config:"TELEGRAM_TOKEN,required" yaml:"token"`
	Whitelist []int64 `config:"AVIA_TELEGRAM_WHITELIST" yaml:"whitelist"`
}

type Logbroker struct {
	Token    string `config:"LOGBROKER_TOKEN,required" yaml:"token"`
	Consumer string `config:"LOGBROKER_CONSUMER" yaml:"consumer"`
	Topic    string `config:"LOGBROKER_TOPIC" yaml:"topic"`
}

var HardcodedWhitelist = func() []int64 {
	whiteListMap := map[int64]interface{}{
		107182153: nil, 86652036: nil, 125323939: nil, 301163632: nil, 182734805: nil,
		64806082: nil, 397003222: nil, 257582730: nil, 194479232: nil, 289063248: nil,
		54584535: "nikhovas",
	}
	var whitelist = make([]int64, 0, len(whiteListMap))
	for k := range whiteListMap {
		whitelist = append(whitelist, k)
	}
	return whitelist
}()
