package flight

import (
	"sort"
	"strings"
	"sync/atomic"
)

type item struct {
	string
	order uint64
}
type History struct {
	CacheSize int
	cache     map[string]item
	counter   uint64
}

func NewFlightHistory(CacheSize int) *History {
	if CacheSize <= 0 {
		CacheSize = 4
	}
	return &History{
		CacheSize: CacheSize,
		cache:     make(map[string]item, CacheSize),
	}
}

func (f *History) SaveFlight(FlightNumber string) {
	FlightNumber = strings.TrimSpace(FlightNumber)
	if len(FlightNumber) == 0 {
		return
	}
	flightNumber := strings.ToLower(FlightNumber)
	if _, exists := f.cache[flightNumber]; !exists {
		f.shrinkCache()
	}
	c := atomic.AddUint64(&f.counter, 1)
	f.cache[flightNumber] = item{FlightNumber, c}
}

func (f *History) GetHistory() []string {
	flights := make([]string, 0, len(f.cache))
	for _, v := range f.cache {
		flights = append(flights, v.string)
	}
	return flights
}

func (f *History) orderedKeys() []string {
	type kOrd struct {
		k string
		o uint64
	}
	keyOrder := make([]kOrd, 0, len(f.cache))
	for k, v := range f.cache {
		keyOrder = append(keyOrder, kOrd{k, v.order})
	}
	sort.Slice(keyOrder, func(i, j int) bool { return keyOrder[i].o < keyOrder[j].o })

	keys := make([]string, 0, len(keyOrder))
	for _, k := range keyOrder {
		keys = append(keys, k.k)
	}
	return keys
}

func (f *History) shrinkCache() {

	for _, k := range f.orderedKeys() {
		if len(f.cache) < f.CacheSize {
			break
		}
		delete(f.cache, k)
	}
}
