package botapi

type Update struct {
	UpdateID int     `json:"update_id"`
	Message  Message `json:"message"`
}

type Message struct {
	MessageID int             `json:"message_id"`
	From      User            `json:"from"`
	Chat      Chat            `json:"chat"`
	Text      string          `json:"text"`
	Entities  []MessageEntity `json:"entities"`
}

var messageEntityTypes = [...]string{
	"mention",       // @username
	"hashtag",       // #hashtag
	"cashtag",       // $USD
	"bot_command",   // /start@jobs_bot
	"url",           // https://telegram.org
	"email",         // do-not-reply@telegram.org
	"phone_number",  // +1-212-555-0123
	"bold",          // bold text
	"italic",        // italic text
	"underline",     // underline text
	"strikethrough", // strikethrough text
	"code",          // monowidth string
	"pre",           // monowidth block
	"text_link",     // for clickable text URLs
	"text_mention",  // for users without usernames
}

type MessageEntity struct {
	Type     string `json:"type"`
	Offset   int    `json:"offset"`
	Length   int    `json:"length"`
	URL      string `json:"url"`
	User     User   `json:"user"`
	Language string `json:"language"`
}

type Chat struct {
	ID int `json:"id"`
}

type User struct {
	ID           int    `json:"id"`
	IsBot        bool   `json:"is_bot"`
	LanguageCode string `json:"language_code"`
}
