package botapi

import "a.yandex-team.ru/library/go/core/log"

type Option interface {
	apply(*Client)
}

type optFunc func(*Client)

func (of optFunc) apply(c *Client) {
	of(c)
}

func Logger(l log.Logger) Option {
	return optFunc(func(c *Client) {
		c.Log = l
	})
}

func Whitelist(chatIDs []int64) Option {
	return optFunc(func(c *Client) {
		c.Whitelist = whitelistFor(chatIDs...)
	})
}
