package pricesubimpl

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/chatbot/public/pricesub"
	result "a.yandex-team.ru/travel/avia/library/proto/search_result/v1"
)

func ChannelLoop(
	ctx context.Context,
	logger log.Logger,
	subscriptions pricesub.SubscriptionRepository,
	subscriberSubscriptions pricesub.SubscriberSubscriptionRepository,
	sendPolicy pricesub.SendPolicy,
	sender pricesub.Sender,
	commonChannel chan *result.Result,
) {

	priceSubscriptionsService := &pricesub.Service{
		Logger:                           logger.WithName("priceSubscriptionService"),
		SubscriptionRepository:           subscriptions,
		SubscriberSubscriptionRepository: subscriberSubscriptions,
		SendPolicy:                       sendPolicy,
		Sender:                           sender,
	}

	for r := range commonChannel {
		if len(r.Variants) == 0 {
			continue
		}
		priceSubscriptionsService.ServeOneSearchResult(ctx, r)
	}
}
