package pricesub

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	result "a.yandex-team.ru/travel/avia/library/proto/search_result/v1"
)

type SubscriptionRepository interface {
	FindSubscriptionsForResult(*result.Result) []*Subscription
}
type SubscriberSubscriptionRepository interface {
	FindSubscriberSubscriptions(Subscription) []SubscriberSubscription
	UpdateLastSeenMinPrice(ctx context.Context, r *result.Result, subsub SubscriberSubscription)
}
type SendPolicy interface {
	ShouldSend(*result.Result, *SubscriberSubscription) bool
}
type Sender interface {
	Send(*result.Result, *SubscriberSubscription)
}
type Service struct {
	Logger log.Logger
	SubscriptionRepository
	SubscriberSubscriptionRepository
	SendPolicy
	Sender
}

func (s *Service) ServeOneSearchResult(ctx context.Context, result *result.Result) {
	subscriptions := s.SubscriptionRepository.FindSubscriptionsForResult(result)
	for _, subscription := range subscriptions {
		subscriberSubscriptions := s.SubscriberSubscriptionRepository.FindSubscriberSubscriptions(*subscription)
		for _, subscriberSubscription := range subscriberSubscriptions {
			if s.SendPolicy.ShouldSend(result, &subscriberSubscription) {
				s.Sender.Send(result, &subscriberSubscription)
				s.SubscriberSubscriptionRepository.UpdateLastSeenMinPrice(ctx, result, subscriberSubscription)
			} else {
				s.Logger.Debug(
					"Not sending result to subscriber",
					log.Any("result", result),
					log.Any("subsub", subscriberSubscription),
				)
			}
		}
	}
}
