package pricesub

import "context"

// High level storage. It knows that Subscriber and Subscription are linked together and manages them
type SubscribeHandler struct {
	SubscriberSaver             SubscriberStorage
	SubscriptionSaver           SubscriptionStorage
	SubscriberSubscriptionSaver SubscriberSubscriptionStorage
}

func (s *SubscribeHandler) Subscribe(ctx context.Context, subscriber Subscriber, subscription Subscription) {
	s.SubscriberSaver.SaveSubscriber(ctx, subscriber)
	s.SubscriptionSaver.SaveSubscription(ctx, subscription)
	s.SubscriberSubscriptionSaver.SaveSubscriberSubscription(ctx, SubscriberSubscription{
		Subscriber:   subscriber,
		Subscription: subscription,
	})
}

type SubscriberStorage interface {
	SaveSubscriber(context.Context, Subscriber)
}

type SubscriptionStorage interface {
	SaveSubscription(context.Context, Subscription)
}

type SubscriberSubscriptionStorage interface {
	SaveSubscriberSubscription(context.Context, SubscriberSubscription)
}
