package searchresult

import "a.yandex-team.ru/travel/avia/library/proto/common/v1"

func ServiceClassToQkeyString(class common.ServiceClass) string {
	switch class {
	case common.ServiceClass_SERVICE_CLASS_ECONOMY:
		return "economy"
	case common.ServiceClass_SERVICE_CLASS_BUSINESS:
		return "business"
	}
	return ""
}

func NationalVersionToString(nv common.NationalVersion) string {
	switch nv {
	case common.NationalVersion_NATIONAL_VERSION_RU:
		return "ru"
	case common.NationalVersion_NATIONAL_VERSION_UA:
		return "ua"
	case common.NationalVersion_NATIONAL_VERSION_TR:
		return "tr"
	case common.NationalVersion_NATIONAL_VERSION_COM:
		return "com"
	case common.NationalVersion_NATIONAL_VERSION_KZ:
		return "kz"
	default:
		return "ru"
	}
}
