package searchresult

import (
	"context"
	"strings"

	"a.yandex-team.ru/kikimr/public/sdk/go/persqueue"
	"a.yandex-team.ru/kikimr/public/sdk/go/persqueue/log/corelogadapter"
	"a.yandex-team.ru/kikimr/public/sdk/go/ydb"
	"a.yandex-team.ru/library/go/core/log"
	result "a.yandex-team.ru/travel/avia/library/proto/search_result/v1"
)

func StartMultiReader(ctx context.Context, endpoints []string, topic string, consumer string, credentials ydb.Credentials, commonChannel chan *result.Result, logger log.Logger) {
	for _, endpoint := range endpoints {
		readerOptions := persqueue.ReaderOptions{
			Logger:               corelogadapter.New(logger.WithName(strings.Join([]string{"persqueue", endpoint}, "_"))),
			Credentials:          credentials,
			Endpoint:             endpoint,
			Consumer:             consumer,
			Topics:               []persqueue.TopicInfo{{Topic: topic}},
			MaxReadMessagesCount: 1,
			MaxReadSize:          100 * 1024 * 1024,
			RetryOnFailure:       true,
		}
		reader, err := NewResultStream(
			ctx,
			readerOptions,
			commonChannel,
			logger.WithName(strings.Join([]string{"search_results", endpoint}, "_")),
		)
		if err != nil {
			logger.Error("Search results", log.Error(err))
			return
		}
		go reader.Go(ctx)
	}
}
