package searchresult

import (
	"context"
	"fmt"
	"time"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/kikimr/public/sdk/go/persqueue"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/library/go/logbroker"
	result "a.yandex-team.ru/travel/avia/library/proto/search_result/v1"
)

type ResultStream struct {
	consumer *logbroker.Reader
	logger   log.Logger
	ch       *messageToResultChannel
}

type messageToResultChannel struct {
	ch     chan<- *result.Result
	logger log.Logger
}

func NewResultStream(ctx context.Context, readerOptions persqueue.ReaderOptions, ch chan<- *result.Result, logger log.Logger) (*ResultStream, error) {
	handler := &messageToResultChannel{ch, logger}
	reader, err := logbroker.NewReader(ctx, readerOptions, logbroker.WithOnMessage(handler.onmessage))
	if err != nil {
		return nil, err
	}
	channel := &ResultStream{consumer: reader, logger: logger, ch: handler}
	return channel, nil
}

func (c *messageToResultChannel) onmessage(message persqueue.ReadMessage) {
	r := &result.Result{}
	err := proto.Unmarshal(message.Data, r)
	if err != nil {
		fmt.Println(err)
	}
	c.logger.Info("To chan", log.Int("#", len(r.GetVariants())), log.Duration("lag", time.Since(message.WriteTime)))
	c.ch <- r
}

func (c *ResultStream) Go(ctx context.Context) {
	for {
		select {
		case <-ctx.Done():
			c.logger.Error("Reader stopped", log.Error(ctx.Err()))
			return
		default:
			err := c.consumer.Read()
			c.logger.Error("Reader stopped", log.Error(err))
		}

	}
}
