# Import submodules so that we can expose their __all__
from travel.avia.contrib.python.mongoengine.mongoengine import connection
from travel.avia.contrib.python.mongoengine.mongoengine import document
from travel.avia.contrib.python.mongoengine.mongoengine import errors
from travel.avia.contrib.python.mongoengine.mongoengine import fields
from travel.avia.contrib.python.mongoengine.mongoengine import queryset
from travel.avia.contrib.python.mongoengine.mongoengine import signals

# Import everything from each submodule so that it can be accessed via
# mongoengine, e.g. instead of `from mongoengine.connection import connect`,
# users can simply use `from mongoengine import connect`, or even
# `from mongoengine import *` and then `connect('testdb')`.
from travel.avia.contrib.python.mongoengine.mongoengine.connection import *
from travel.avia.contrib.python.mongoengine.mongoengine.document import *
from travel.avia.contrib.python.mongoengine.mongoengine.errors import *
from travel.avia.contrib.python.mongoengine.mongoengine.fields import *
from travel.avia.contrib.python.mongoengine.mongoengine.queryset import *
from travel.avia.contrib.python.mongoengine.mongoengine.signals import *


__all__ = (
    list(document.__all__)
    + list(fields.__all__)
    + list(connection.__all__)
    + list(queryset.__all__)
    + list(signals.__all__)
    + list(errors.__all__)
)


VERSION = (0, 19, 1)


def get_version():
    """Return the VERSION as a string.

    For example, if `VERSION == (0, 10, 7)`, return '0.10.7'.
    """
    return ".".join(map(str, VERSION))


__version__ = get_version()
