from typing import Dict, List


# PROBLEM
# For some cases data for children can be very different from parent data, so we should not add parent's metrics
# to these children
# For example: Bali is opened for tourism, but Indonesia at all is closed.
# Without exceptions management Bali can be also closed for tourists in table data, but it is not so.

# SOLUTION
# Add new parent hierarchy for managing exceptions.
# First, the program should try to get parent from exception list,
# and only if there is no data in exceptions, get data from ordinary list.


# parent exceptions list
CUSTOM_PARENTS: Dict[str, List[str]] = {
    'r10572': [],  # Bali as a country
    # declare Madeira
    'c22320': ['r22418', 'l10074'],
    'r22418': ['l10074'],
}
