import datetime

from travel.avia.country_restrictions.lib.geo_format_manager import GeoFormatManager
from travel.avia.country_restrictions.lib.types.metric_type import TOURISM_AVAILABILITY, \
    TOURISM_AVAILABLE_FROM_METRIC_TYPE
from travel.avia.country_restrictions.lib.types import CountryInfo


def processor(point_key: str, data: CountryInfo, geo_format_manager: GeoFormatManager) -> CountryInfo:
    tourism_availability = data.get(TOURISM_AVAILABILITY.name, None)
    tourism_available_from = data.get(TOURISM_AVAILABLE_FROM_METRIC_TYPE.name, None)

    if tourism_availability is None or tourism_available_from is None:
        return data

    tourism_available_from_date = datetime.datetime.strptime(tourism_available_from.value, '%Y-%m-%d').date()
    current_date = datetime.datetime.now().date()
    if current_date >= tourism_available_from_date:
        data[TOURISM_AVAILABILITY.name] = TOURISM_AVAILABILITY.generate_metric(True)
        data[TOURISM_AVAILABILITY.name].union_metadata_from_another_metric(tourism_available_from)
        data.pop(TOURISM_AVAILABLE_FROM_METRIC_TYPE.name)
    elif tourism_availability.value is True:
        data.pop(TOURISM_AVAILABLE_FROM_METRIC_TYPE.name)

    return data
