from travel.avia.country_restrictions.lib.geo_format_manager import GeoFormatManager
from travel.avia.country_restrictions.lib.types.metric_type import FLIGHTS_AVAILABILITY, FLIGHTS_AVAILABILITY_V2
from travel.avia.country_restrictions.lib.types import CountryInfo


RUSSIA_POINT_KEY = 'l225'


def processor(point_key: str, data: CountryInfo, geo_format_manager: GeoFormatManager) -> CountryInfo:
    if geo_format_manager.has_point_key_in_hierarchy(point_key, RUSSIA_POINT_KEY):
        data.pop(FLIGHTS_AVAILABILITY.name, None)
        data.pop(FLIGHTS_AVAILABILITY_V2.name, None)

    return data
